/*------------------------------------------------------------------------------*
 * File Name: MDFFile.h				 										*
 * Purpose: Declare functions defined n FileImport.c							*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 07/09/07 v8.0655 IMPORT_RAW_DATA_FOR_MAY_FORMULA						*
 *	Hong 07/07/09 QA80-13884 ADD_OPTION_TO_SUPPORT_WHETHER_IMPORT_WITH_DATA_GROUP_OR_NOT
 *------------------------------------------------------------------------------*/

#ifndef _MDFFile_H
#define _MDFFile_H

#include <Tree.h>
#include "file_utils.h"
#pragma pack(push,1) //---CPY 7/5/06


/// This is used for general info
struct IDBlockStruc{
	char BlockID [8];						// should start with "MDF"
	char FormatID [8];						//Start with "2.00" or "3.00" , 
	char ProgramID [8];
	unsigned short ByteOrder;
	unsigned short FloatFormat;
	unsigned short VersNumber;
//	char Reserve1 [2];    // can add later
//	char Reserve2 [30];
};

// Start from 64 offset in the file, 
struct HDBlockStruc{
	char BlockID [2];						//should be "HD"
	unsigned short BlockSize;
	int PDGBlock;							// the position of the DG information block (DGIB)
	int PTXBlock;
	int PProgBlock;
	unsigned short NumberDataGroups;		//Number of DG  
	char date [10];
	char time [8];
	char Author [32];
	char department [32];
	char ProjName [32];
	char MeasObj [32];
};
/*
struct TXBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	char Remark [255];
};

struct PRBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	char Remark [80];
};
*/
struct TXBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
};

struct DGBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	int PNextDGBlock;						//the position of Next DG information block 
	int PNextChannel;						// the position of CG information block.
	int PReserve;
	int PDataRecords;						//the position of Data Records
	unsigned short NumberChGroups;			// The number of CG, should be 1. A DG has only one CG.
	unsigned short NumberRecordID;			
//	unsigned int Reserve;         can add later
};

struct CGBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	int PNextChannelBlock;					// ignor, should be 0
	int PFirstChannel;						// The position of first Channerl Group 
	int PRemark;							// 'pointerToChannelGroupCommentText'; ...
	unsigned short RecordID;
	unsigned short NumberChannels;
	unsigned short RecordSize;
//	byte NumRec1;
//	byte NumRec2;
//	byte NumRec3;
//	byte NumRec4;
	unsigned int NumberRecords;
//	unsigned short NumberFirstChannel;
//	int CTRreadRecords;                  //counter of number of already read data records
//  float LastTime;
//    bool finished;						// all data records have been read
};

struct CNBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	int PNextBlock;						//the position of Next CNIB
	int PCCBlock;						//The position of CCIB
	int PReserve1;
	int PReserve2;
	int PTXBlock;
	unsigned short ChannelType;			//1 means Time CN, 0 means signal channel
	char SignalName [32];
	char SignalDescr [128];
	unsigned short NumberFirstBit;		//This channel data start at this bit index in record(numberOfTheFirstBits)
	unsigned short NumberBits;			// Bit Number of this channel data in record 1, 8, or 16
	unsigned short SignalType;
	unsigned short ValidRange;			// this should be a boolean, but in OC, BOOL is int
	double MinRange;
	double MaxRange;
	double SampleRange;
	int PTXBlockUniqueName;		///---Sim 10-20-2006 MISSING_DATA
	int PTXBlockSignal;
	unsigned short ByteOffset;                // New for MDF Version 3.0
};

struct CCBlockStruc{
	char BlockID [2];
	unsigned short BlockSize;
	unsigned short ValidRange;
	double  PhysMin;
	double  PhysMax;
	char Unit [20];
	unsigned short FormulaID;			//conversion Formula Identifier; ..
	unsigned short NumberValuePairs;	// number Of ValuePairs
};

///---Sim 10-10-2006 FORMULA_ID
#define MDF_FORMULA_TAGNAME "MDFFileFormula"
//Move to VC level
/*
enum{
	MDF_FM_PARALINE = 0,
	MDF_FM_TABINTERP,
	MDF_FM_TAB,
	MDF_FM_POLYFUNC = 6,
	MDF_FM_EXPFUNC,
	MDF_FM_LOGFUNC,
	MDF_FM_ASAP2RCF,
	MDF_FM_ASAMMCD2TF,
	MDF_FM_ASAMMCD2TT,
	MDF_FM_ASAMMCD2TRT,
	MDF_FM_DATE = 132,
	MDF_FM_TIME = 133,
};
*/
///---END FORMULA_ID

///---Sim 09-25-2006 VARIABLE_PARAMETER
typedef struct tagCCFormatFormula0{
    double   P1;
    double   P2;
}CCFormatFormula0;

typedef struct tagCCFormatFormula1{  // Tablular or Tabular with interp
    double   interp;
    double   phys;
}CCFormatFormula1;

typedef struct tagCCFormatFormula2{  // Tablular or Tabular
    double   interp;
    double   phys;
}CCFormatFormula2;


typedef struct tagCCFormatFormula6{  // Polynomial
    double   P1; 	
    double   P2; 	
    double   P3;	
    double   P4; 	
    double   P5;	
    double   P6;	
}CCFormatFormula6;

typedef struct tagCCFormatFormula7{  // exponential function
    double   P1;
    double   P2;
    double   P3;
    double   P4;
    double   P5;
    double   P6;
    double   P7;
}CCFormatFormula7;

typedef struct tagCCFormatFormula8{  // Logarithmic
    double   P1;
    double   P2;
    double   P3;
    double   P4;
    double   P5;
    double   P6;
    double   P7;
}CCFormatFormula8;

typedef struct tagCCFormatFormula9{  // ASAP2 Rational conversion formula
    double   P1;
    double   P2;
    double   P3;
    double   P4;
    double   P5;
    double   P6;
}CCFormatFormula9;

typedef struct tagCCFormatFormula10{ //Text formula
    char   strFormula[256];
}CCFormatFormula10;

typedef struct tagCCFormatFormula11{ // ASAM-MCD2 text table
    double  interp;
    char strtext[32];
}CCFormatFormula11;
///---END VARIABLE_PARAMETER

///---Sim 09-25-2006 VARIABLE_PARAMETER
/*
struct CCFormatFormula6={...
    double   P1; 	//... % polynomial
    double   P2; 	//...
    double   P3;	// ...
    double   P4; 	//...
    double   P5;	//'; ...
    double   P6;	//
};
*/
///---END VARIABLE_PARAMETER

#pragma pack(pop) //---CPY 7/5/06

#define STR_SINGLE_SHORT_GROUP 	"SingleShotGroup"
#define STR_REMARK_TITLE		"Remark"
#define HD_BALOCK_START_POS 64

#define STR_CHANNEL_GROUP_INDEX	"CGIndex"/// Hong 06/19/07 v8.0644 FIX_FAIL_CORRECT_UNCHECK_ACCORDING_X_COLUMN

// to use this need define string strTX first;
///---Sim 10-20-2006 PASS_STRING_TO_MACRO
#define READ_TX_BLOCK(_strTX, _nPOs_) \
	TXBlockStruc _txTemp_; \
	Seek(_nPOs_, file::begin);	\
	if ( Read(&_txTemp_, sizeof(TXBlockStruc) ) != sizeof(TXBlockStruc) )  \
		/*return IMPERR_MDF_FAILED_TO_READ_TX_BLOCK; */ ;\
	if ( ( _txTemp_.BlockSize - sizeof(TXBlockStruc) ) > 0 )  \  
	{ \
		char* pBuffer =(char*)malloc(_txTemp_.BlockSize - sizeof(TXBlockStruc)); \
		if ( Read(pBuffer, _txTemp_.BlockSize- sizeof(TXBlockStruc)) != (_txTemp_.BlockSize - sizeof(TXBlockStruc)) )  \
			return IMPERR_MDF_FAILED_TO_READ_TX_BLOCK; \
		_strTX = pBuffer; \
		free(pBuffer); \
	} 
///---END PASS_STRING_TO_MACRO
///--- justin 7/11/2006 REVISE_THE_TEXT_BLOCK_SIZE
//#define READ_AND_ADD_TX_BLOCK(_nPOs_, _TreeParent_, _strName_ ) \
	//TXBlockStruc _txTemp_; \
	//Seek(_nPOs_, file::begin);	\
	//if ( Read(&_txTemp_, sizeof(TXBlockStruc) ) != sizeof(TXBlockStruc) )  \
		//return IMPERR_FILE_READ; \
	//if ( _txTemp_.BlockSize > 0 ) \
	//{ \
		//if ( Read(&strTX, _txTemp_.BlockSize ) != _txTemp_.BlockSize )  \
			//return IMPERR_FILE_READ; \
		//_TreeParent_.AddTextNode(strTX, _strName_); \
	//}
///---Sim 11-09-2006 HANDLE_ERROR_MESSAGE
#define READ_AND_ADD_TX_BLOCK(_nPOs_, _TreeParent_, _strName_ ) \
	TXBlockStruc _txTemp_; \
	Seek(_nPOs_, file::begin);	\
	if ( Read(&_txTemp_, sizeof(TXBlockStruc) ) != sizeof(TXBlockStruc) )  \
		return IMPERR_MDF_FAILED_TO_READ_TX_BLOCK; \
	if ( _txTemp_.BlockSize - sizeof(TXBlockStruc)> 0 ) \
	{ \
		char* pBuffer =(char*)malloc(_txTemp_.BlockSize - sizeof(TXBlockStruc)); \
		if ( Read(pBuffer, _txTemp_.BlockSize- sizeof(TXBlockStruc)) != (_txTemp_.BlockSize - sizeof(TXBlockStruc)) )  \
			return IMPERR_MDF_FAILED_TO_READ_TX_BLOCK; \
		strTX = pBuffer; \
		free(pBuffer); \
		_TreeParent_.AddTextNode(strTX, _strName_); \
	}
///---END HANDLE_ERROR_MESSAGE
///end REVISE_THE_TEXT_BLOCK_SIZE

///---Sim 11-09-2006 HANDLE_ERROR_MESSAGE
#define READ_BLOCK(_StructType_, _StructName_, _nPOs_) _StructType_ _StructName_; \
	Seek(_nPOs_, file::begin);	\
	if ( Read(&_StructName_, sizeof(_StructType_) ) != sizeof(_StructType_) ) \
		return IMPERR_FAILED_READ;	
///---END HANDLE_ERROR_MESSAGE

#define ADD_BLOCK_IN_TREE(_StructName_, _TreeParent_, _TreeChild_, _strName_) \
	TreeNode _TreeChild_= _TreeParent_.AddNode(_strName_); \
	_TreeChild_ = _StructName_;	
	
#define ADD_BLOCK_IN_TREE2(_StructName_, _TreeParent_, _TreeChild_, _strName_) \
	_TreeChild_= _TreeParent_.AddNode(_strName_); \
	_TreeChild_ = _StructName_;	


#define READ_AND_ADD_BLOCK(_StructType_, _StructName_, _nPOs_, _TreeParent_, _TreeChild_, _strName_ ) \
	READ_BLOCK(_StructType_, _StructName_, _nPOs_) \
	ADD_BLOCK_IN_TREE(_StructName_, _TreeParent_, _TreeChild_, _strName_)

	
#define READ_ID_BLOCK(_StructName_, _TreeParent_, _TreeChild_) \
	READ_AND_ADD_BLOCK(IDBlockStruc, _StructName_, 0, _TreeParent_, _TreeChild_, "MDF")

#define READ_HD_BLOCK(__StructName_, __nPOs_, __TreeParent_, __TreeChild_) \
	READ_AND_ADD_BLOCK(HDBlockStruc, __StructName_, __nPOs_, __TreeParent_, __TreeChild_, "HD")
	
	
	
#define READ_DG_BLOCK(_StructName_, _nPOs_) \
	READ_BLOCK(DGBlockStruc, _StructName_, _nPOs_)
	
#define READ_CG_BLOCK(_StructName_, _nPOs_) \
	strTX.Empty(); \
	READ_BLOCK(CGBlockStruc, _StructName_, _nPOs_) \
	if ( _StructName_.PRemark > 0) \
	{ \
		READ_TX_BLOCK(strTX, _StructName_.PRemark) /*---Sim 10-20-2006 PASS_STRING_TO_MACRO*/ \
	} 
	
#define READ_CC_BLOCK(_StructName_, _nPOs_, _TreeParent_, _TreeChild_) \
	READ_AND_ADD_BLOCK(CCBlockStruc, _StructName_, _nPOs_, _TreeParent_, _TreeChild_, "CC") 
//---Sim 10-13-2006 NOT_RIGHT_LAOD_PARAMETERS 
/*
#define ADD_CC_PARA( _trCC_, _nNumberValuePairs_) \
	if ( _nNumberValuePairs_ > 0 ) \
	{ \
		TreeNode trVars = _trCC_.AddNode("Vars"); \
		vector<double> vdPara(_nNumberValuePairs_); \
		Read(vdPara, _nNumberValuePairs_ * 8 ); \
		trVars.dVals = vdPara; \
	}
*/
//---END NOT_RIGHT_LAOD_PARAMETERS 
//#define ADD_CC_PARA( _trCC_, _nNumberValuePairs_) \
	//if ( _nNumberValuePairs_ > 0 ) \
	//{ \
		//TreeNode trVars = _trCC_.AddNode("Vars"); \
		//double dTemp; \
		//for (int kk = 0; kk < _nNumberValuePairs_; kk++ ) \
		//{ \
			//Read(&dTemp, 8); \
			//trVars.AddNumericNode(dTemp, "Var"); \
		//} \
	//}
	
//#define READ_CN_BLOCK(_StructName_, _nPOs_, _TreeParent_, _TreeChild_, _CGNumberRecords_) \
	//strTX.Empty(); \
	//READ_BLOCK(CNBlockStruc, _StructName_, _nPOs_) \
	//if ( _StructName_.PTXBlock > 0) \
	//{ \
		//READ_TX_BLOCK(_StructName_.PTXBlock) \
	//} \  
	//if ( ( _StructName_.SignalName[0]!= '$' ) && _CGNumberRecords_ > 0 ) \
	//{ \
		//ADD_BLOCK_IN_TREE2(_StructName_, _TreeParent_, _TreeChild_, "CN") \
		//_TreeChild_.AddTextNode(strTX, "TX"); \
	//} 
///---Sim 10-20-2006 MORE_MODIFIED_IN_CN_BLOCK_READER
#define READ_CN_BLOCK(_StructName_, _nPOs_, _TreeParent_, _TreeChild_) \
	string _strTX = "", _strUniqueName = "", _strSignal = "";\
	READ_BLOCK(CNBlockStruc, _StructName_, _nPOs_) \
	if ( _StructName_.PTXBlock > 0) \
	{ \
		READ_TX_BLOCK(_strTX, _StructName_.PTXBlock) \
	} \  
	if ( _StructName_.PTXBlockUniqueName > 0 ) \
	{ \
		READ_TX_BLOCK(_strUniqueName, _StructName_.PTXBlockUniqueName) \
	} \
	if ( _StructName_.PTXBlockSignal > 0 ) \
	{ \
		READ_TX_BLOCK(_strSignal, _StructName_.PTXBlockSignal) \
	} \
	_StructName_.SignalName[31] = '\0'; /*---Sim 10-20-2006 MAKE_RELIABLE_CHAR_ARRAY*/ \
	ADD_BLOCK_IN_TREE2(_StructName_, _TreeParent_, _TreeChild_, "CN") \
	_TreeChild_.AddTextNode(_strTX, "TX"); \
	_TreeChild_.AddTextNode(_strUniqueName, "UniqueName"); \
	_TreeChild_.AddTextNode(_strSignal, "Signal");  
///---END MORE_MODIFIED_IN_CN_BLOCK_READER

///--- Justin 7/13/2006 FASTER_IMPORT_DATA
#define GET_NUMERIC_CN( _Formula_, _dTemp_, _nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_, _DataType_) \
	for(int ii=0; ii < _nNumRecs_ ; ii++) \
	{ \
		_dTemp_ = *(_DataType_ *) _pbDataSrc_; \
		_Formula_ \
		_dsDet_[ii] = _dTemp_; \
		_pbDataSrc_ += _nRecordSize_; \
	}
#define GET_TEXT_CN(_nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_,_nNumBits_) \
	for(int ii=0; ii < _nNumRecs_ ; ii++) \
	{ \
		string strTemp(_pbDataSrc_, _nNumBits_/8);  \
		_dsDet_.SetText(ii, strTemp); \ 
		_pbDataSrc_ += _nRecordSize_; \
	}
#define FORMULA0(_dTemp_, _vdPara_) \
	_dTemp_ = _vdPara_[0] + _vdPara_[1] *_dTemp_ ;
#define FORMULA65535 \
	;
/// AW 07/13/06 MORE_ON_FASTER_IMPORT_DATA	
#define GET_CN_DATA(_vdPara_, _dTemp_, _nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_, _DataType_) \
		switch( iFormulaID ) \
		{ \
			case 0: \
				GET_NUMERIC_CN( FORMULA0(_dTemp_,_vdPara_), _dTemp_,_nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_, _DataType_); \
				break; \
			default: \
				GET_NUMERIC_CN(FORMULA65535, _dTemp_,_nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_, _DataType_) \
		} \
		break;
/// END MORE_ON_FASTER_IMPORT_DATA
///---end FASTER_IMPORT_DATA	

///justin 09/22/2006 QA70-8698 FULL_SUPPORT_MDF300
#define READ_NUMERIC_CN( _nNumRecs_, _nRecordSize_, _pbDataSrc_, _dsDet_, _DataType_) \
	for(int ii=0; ii < _nNumRecs_ ; ii++) \
	{ \
		_dsDet_[ii] = (double)*(_DataType_ *) _pbDataSrc_; \
		_pbDataSrc_ += _nRecordSize_; \
	}
#define READ_TEXT_CN(_nNumRecs_,_nRecordSize_, _pbDataSrc_, _dsDet_, _nNumBits_) \
	for(int ii=0; ii < _nNumRecs_ ; ii++) \
	{ \
		string strTemp(_pbDataSrc_, _nNumBits_/8);  \
		_dsDet_.SetText(ii, strTemp); \ 
		_pbDataSrc_ += _nRecordSize_; \
	}

//end FULL_SUPPORT_MDF300

/// Hong 9/25/06 ADD_TYPE_SUPPORT_BTYE_ARRAY
#define READ_BYTEARRAY_CN(_nNumRecs_, _nRecordSize_, _pbDataSrc_, _vec_, _nNumBits_ ) \
	_vec_.SetSize(0); \
	byte *pTemp = _pbDataSrc_; \
	for(int ii=0; ii < _nNumRecs_ ; ii++) \
	{ \
		_pbDataSrc_ = pTemp; \
		for(int jj=0; jj < _nNumBits_; jj++) \
		{ \
			_vec_.Add(*(byte *) _pbDataSrc_); \
			_pbDataSrc_ += 8; \
		} \
		pTemp += _nRecordSize_; \
	}
/// END ADD_TYPE_SUPPORT_BTYE_ARRAY

class MDFFile : public BinFile
{
public:
	MDFFile(BOOL bImport = true)
	:BinFile(bImport) 
	{ 
 		m_bImportRawData = false; /// Hong 07/09/07 v8.0655 IMPORT_RAW_DATA_FOR_MAY_FORMULA
 		m_bEnableDataGroup = false; /// Hong 07/07/09 QA80-13884 ADD_OPTION_TO_SUPPORT_WHETHER_IMPORT_WITH_DATA_GROUP_OR_NOT
	}
public:
	/// AW 07/12/06 MOVE_MDF_TO_XF
	//	int ReadFile(LPCSTR lpcszFilePath);
	//	int GetResult();
	///---Sim 09-26-2006 SUPPORT_SPARKLINES
	//int Import(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo);
	///---Sim 09-29-2006 SUPPORT_DATA_SELECTION
	//int Import(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo, bool bSparkLines = FALSE);
	/// Hong 06/08/07 QA80-9890 IMPORT_ALL_DATA_TO_ONE_SHEET
	//int Import(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo, TreeNode& trFileNode = NULL, bool bSparkLines = FALSE);
	/// Hong 07/09/07 v8.0655 IMPORT_RAW_DATA_FOR_MAY_FORMULA
	//int Import(LPCSTR lpcszFileName, Worksheet& wks, TreeNode& trFileInfo, TreeNode& trFileNode = NULL, int nC1 = 0, int nC2 = -1);
	int Import(LPCSTR lpcszFileName, Worksheet& wks, TreeNode& trFileInfo, TreeNode& trFileNode = NULL, int nC1 = 0, int nC2 = -1, bool bImportRawData = false);
	/// end IMPORT_RAW_DATA_FOR_MAY_FORMULA
	/// end IMPORT_ALL_DATA_TO_ONE_SHEET
	///---END SUPPORT_DATA_SELECTION
	///---END SUPPORT_SPARKLINES
	/// END MOVE_MDF_TO_XF
	///---Sim 09-29-2006 CALL_BY_XF_FOR_USER_DATA_SELECTION
	int ReadHeader(LPCSTR lpcszFileName, TreeNode& trFileInfo);
	///---END CALL_BY_XF_FOR_USER_DATA_SELECTION
	
	/// Hong 07/07/09 QA80-13884 ADD_OPTION_TO_SUPPORT_WHETHER_IMPORT_WITH_DATA_GROUP_OR_NOT
	void SetDataGroup(bool bEnable);
	int  GetDataSelection(LPCSTR lpcszFileName, TreeNode& trFileNode);
	/// end ADD_OPTION_TO_SUPPORT_WHETHER_IMPORT_WITH_DATA_GROUP_OR_NOT

private:
	int ReadCNInf(int nPos, TreeNode&trParent, TreeNode& trCNRet);
	///---Sim 09-29-2006 SUPPORT_DATA_SELECTION
	//int ReadDGData(Worksheet &wks, TreeNode& trDG, int iFirstCol );
	/// Hong 06/08/07 QA80-9890 IMPORT_ALL_DATA_TO_ONE_SHEET
	//int ReadDGData(Worksheet &wks, LPCSTR lpcszFileName, TreeNode& trDG, int iFirstCol, TreeNode& trDGSetting = NULL);
	int ReadDGData(Worksheet &wks, LPCSTR lpcszFileName, TreeNode& trDG, TreeNode& trChannel, int& nC1, int& nC2);
	/// end IMPORT_ALL_DATA_TO_ONE_SHEET
	///---END SUPPORT_DATA_SELECTION
	///---Sim 09-25-2006 VARIABLE_PARAMETER
	//BOOL ApplyFormular(Column& colCC, vector<double>& vdPara, int iFormulaID);
	/// Hong 07/09/07 v8.0655 IMPORT_RAW_DATA_FOR_MAY_FORMULA
	//BOOL ApplyFormular(Column& colCC, TreeNode& trCN);
	BOOL ApplyFormular(Column& colCC, TreeNode& trCN, int& nC1, int& nC2);
	/// end IMPORT_RAW_DATA_FOR_MAY_FORMULA
	///---END VARIABLE_PARAMETER


protected:
	///---Sim 10-10-2006 GET_SHOWING_FILE_INFO
	BOOL GetUsefulFileInfo(TreeNode& trUsefulInfo, const TreeNode& trInfo, const TreeNode& trFileSetting);
	///---END GET_SHOWING_FILE_INFO
	
	/// AW 07/12/06 MOVE_MDF_TO_XF
	///---Sim 09-26-2006 SUPPORT_SPARKLINES
	//int ReadData(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo);
	///---Sim 09-29-2006 SUPPORT_DATA_SELECTION
	//int ReadData(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo, bool bSparklines = FALSE);
	/// Hong 06/08/07 QA80-9890 IMPORT_ALL_DATA_TO_ONE_SHEET
	//int ReadData(LPCSTR lpcszFileName, WorksheetPage& wkspg, TreeNode& trFileInfo, TreeNode& trFileNode = NULL, bool bSparkLines = FALSE);
	int ReadData(LPCSTR lpcszFileName, Worksheet& wks, TreeNode& trFileInfo, TreeNode& trFileNode, int nC1, int nC2);
	/// end IMPORT_ALL_DATA_TO_ONE_SHEET
	///---END SUPPORT_DATA_SELECTION
	///---END SUPPORT_SPARKLINES
	///---Sim 09-29-2006 CALL_BY_XF_FOR_USER_DATA_SELECTION
	//int ReadHeader(LPCSTR lpcszFileName, TreeNode& trFileInfo);
	///---END CALL_BY_XF_FOR_USER_DATA_SELECTION
	/// END MOVE_MDF_TO_XF

	//justin 7/11/2006 ADD_CODE_TO_DEAL_WITH_SEVERAL_BITS_DATA 
	//double getCNValue(int nDataType,  byte* pbOriginData, int iFormulaID, vector<double>& vdPara);
	double getCNValue(int nDataType,  byte* pbOriginData, int nBitOffset, int iFormulaID, vector<double>& vdPara);
	//end ADD_CODE_TO_DEAL_WITH_SEVERAL_BITS_DATA
	int getDataTypeFromat(unsigned short numberOfBits, unsigned short SignalType );
//	Tree m_trResult;
	bool ConvertFileInfo(TreeNode& trFileInfo, TreeNode& trHdrStruct);
	
protected:
	///---Sim 10-10-2006 SUPPORT_PROGRESS_SHOW
	progressBox *m_pProgress;
	int m_nDataCount;
	bool m_bUserCancel;
	///---END SUPPORT_PROGRESS_SHOW
	bool m_bImportRawData; /// Hong 07/09/07 v8.0655 IMPORT_RAW_DATA_FOR_MAY_FORMULA 
	
	bool 		m_bEnableDataGroup; /// Hong 07/07/09 QA80-13884 ADD_OPTION_TO_SUPPORT_WHETHER_IMPORT_WITH_DATA_GROUP_OR_NOT
};



#endif // _MDFFile_H



//	
